/**
* \file: AirPlayReceiverServerHooks.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

// TODO error handling

#include "AirPlayHeaders.h"

#include "Common.h"
#include "Server.h"

using namespace adit::carplay;

extern "C" {

// symbol replacement hooks for Apple communication plug-in core defined in this file:
CARPLAY_EXPORTED OSStatus  _AirPlayReceiverServerPlatformInitialize(
        AirPlayReceiverServerRef inServer);
CARPLAY_EXPORTED void      _AirPlayReceiverServerPlatformFinalize(
        AirPlayReceiverServerRef inServer);

// some APIs require us to cast from CFTypeRef to e.g. AirPlayReceiverServerRef const
// which is: const void* -> void* -> void* const
//#define CAST_FROM_CFTYPE(type, obj) reinterpret_cast<type>(const_cast<void*>(obj))
//commented as SA findings and no where its used

OSStatus _AirPlayReceiverServerPlatformInitialize(AirPlayReceiverServerRef inServer)
{
    auto server = Server::Add(inServer);
    if ( server  == nullptr )
    {
        LOG_ERROR((dipo, "Server Add failed"));
        return kUnknownErr;
    }
    return server->Initialize() ? kNoErr : kUnknownErr;
}

void _AirPlayReceiverServerPlatformFinalize(AirPlayReceiverServerRef inServer)
{
    Server::Remove(inServer);
}

} // extern "C"
